# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def benevolent_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    total_rounds = 10
    current_round = len(my_history) + 1
    
    # Initial Phase: Start cooperatively
    if current_round <= 3:
        if "D" in opp_history:
            return "D"  # Trigger hard retaliation
        return "C"
    
    # Mid-Game: Test opponent's forgiveness
    if current_round <= 7:
        if all(move == "C" for move in opp_history[:3]):
            if "forgive" in opponent_program_code.lower() or "C" in opponent_program_code[-100:]:
                if current_round == 4:
                    return "D"  # Test forgiveness
                if current_round == 6 and opp_history[3] == "C":
                    return "D"  # Exploit if still cooperating
            return "C"
        else:
            return "D" if "D" in opp_history else "C"
    
    # Late-Game: Maximize payoff
    if current_round >= 8:
        if all(move == "C" for move in opp_history):
            if "current_round >= total_rounds - 1" in opponent_program_code:
                return "D"  # Preempt late defection
            # Alternate to avoid predictability
            return "D" if current_round % 2 == 0 else "C"
        else:
            return "D"  # Continue retaliation if opponent defected
    
    return "C"  # Fallback (shouldn't reach here)